// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class DeviceTwinInfoX509Thumbprint : IUtf8JsonSerializable, IJsonModel<DeviceTwinInfoX509Thumbprint>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DeviceTwinInfoX509Thumbprint>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DeviceTwinInfoX509Thumbprint>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeviceTwinInfoX509Thumbprint>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DeviceTwinInfoX509Thumbprint)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(PrimaryThumbprint))
            {
                writer.WritePropertyName("primaryThumbprint"u8);
                writer.WriteStringValue(PrimaryThumbprint);
            }
            if (Optional.IsDefined(SecondaryThumbprint))
            {
                writer.WritePropertyName("secondaryThumbprint"u8);
                writer.WriteStringValue(SecondaryThumbprint);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DeviceTwinInfoX509Thumbprint IJsonModel<DeviceTwinInfoX509Thumbprint>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeviceTwinInfoX509Thumbprint>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DeviceTwinInfoX509Thumbprint)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDeviceTwinInfoX509Thumbprint(document.RootElement, options);
        }

        internal static DeviceTwinInfoX509Thumbprint DeserializeDeviceTwinInfoX509Thumbprint(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string primaryThumbprint = default;
            string secondaryThumbprint = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("primaryThumbprint"u8))
                {
                    primaryThumbprint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("secondaryThumbprint"u8))
                {
                    secondaryThumbprint = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DeviceTwinInfoX509Thumbprint(primaryThumbprint, secondaryThumbprint, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DeviceTwinInfoX509Thumbprint>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeviceTwinInfoX509Thumbprint>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DeviceTwinInfoX509Thumbprint)} does not support writing '{options.Format}' format.");
            }
        }

        DeviceTwinInfoX509Thumbprint IPersistableModel<DeviceTwinInfoX509Thumbprint>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeviceTwinInfoX509Thumbprint>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDeviceTwinInfoX509Thumbprint(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DeviceTwinInfoX509Thumbprint)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DeviceTwinInfoX509Thumbprint>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DeviceTwinInfoX509Thumbprint FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDeviceTwinInfoX509Thumbprint(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
