// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Information about the device twin, which is the cloud representation of application device metadata. </summary>
    public partial class DeviceTwinInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeviceTwinInfo"/>. </summary>
        /// <param name="properties"> Properties JSON element. </param>
        /// <param name="x509Thumbprint"> The thumbprint is a unique value for the x509 certificate, commonly used to find a particular certificate in a certificate store. The thumbprint is dynamically generated using the SHA1 algorithm, and does not physically exist in the certificate. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="properties"/> or <paramref name="x509Thumbprint"/> is null. </exception>
        internal DeviceTwinInfo(DeviceTwinInfoProperties properties, DeviceTwinInfoX509Thumbprint x509Thumbprint)
        {
            Argument.AssertNotNull(properties, nameof(properties));
            Argument.AssertNotNull(x509Thumbprint, nameof(x509Thumbprint));

            Properties = properties;
            X509Thumbprint = x509Thumbprint;
        }

        /// <summary> Initializes a new instance of <see cref="DeviceTwinInfo"/>. </summary>
        /// <param name="authenticationType"> Authentication type used for this device: either SAS, SelfSigned, or CertificateAuthority. </param>
        /// <param name="cloudToDeviceMessageCount"> Count of cloud to device messages sent to this device. </param>
        /// <param name="connectionState"> Whether the device is connected or disconnected. </param>
        /// <param name="deviceId"> The unique identifier of the device twin. </param>
        /// <param name="etag"> A piece of information that describes the content of the device twin. Each etag is guaranteed to be unique per device twin. </param>
        /// <param name="lastActivityTime"> The ISO8601 timestamp of the last activity. </param>
        /// <param name="properties"> Properties JSON element. </param>
        /// <param name="status"> Whether the device twin is enabled or disabled. </param>
        /// <param name="statusUpdateTime"> The ISO8601 timestamp of the last device twin status update. </param>
        /// <param name="version"> An integer that is incremented by one each time the device twin is updated. </param>
        /// <param name="x509Thumbprint"> The thumbprint is a unique value for the x509 certificate, commonly used to find a particular certificate in a certificate store. The thumbprint is dynamically generated using the SHA1 algorithm, and does not physically exist in the certificate. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeviceTwinInfo(string authenticationType, float? cloudToDeviceMessageCount, string connectionState, string deviceId, string etag, string lastActivityTime, DeviceTwinInfoProperties properties, string status, string statusUpdateTime, float? version, DeviceTwinInfoX509Thumbprint x509Thumbprint, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AuthenticationType = authenticationType;
            CloudToDeviceMessageCount = cloudToDeviceMessageCount;
            ConnectionState = connectionState;
            DeviceId = deviceId;
            Etag = etag;
            LastActivityTime = lastActivityTime;
            Properties = properties;
            Status = status;
            StatusUpdateTime = statusUpdateTime;
            Version = version;
            X509Thumbprint = x509Thumbprint;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DeviceTwinInfo"/> for deserialization. </summary>
        internal DeviceTwinInfo()
        {
        }

        /// <summary> Authentication type used for this device: either SAS, SelfSigned, or CertificateAuthority. </summary>
        public string AuthenticationType { get; }
        /// <summary> Count of cloud to device messages sent to this device. </summary>
        public float? CloudToDeviceMessageCount { get; }
        /// <summary> Whether the device is connected or disconnected. </summary>
        public string ConnectionState { get; }
        /// <summary> The unique identifier of the device twin. </summary>
        public string DeviceId { get; }
        /// <summary> A piece of information that describes the content of the device twin. Each etag is guaranteed to be unique per device twin. </summary>
        public string Etag { get; }
        /// <summary> The ISO8601 timestamp of the last activity. </summary>
        public string LastActivityTime { get; }
        /// <summary> Properties JSON element. </summary>
        public DeviceTwinInfoProperties Properties { get; }
        /// <summary> Whether the device twin is enabled or disabled. </summary>
        public string Status { get; }
        /// <summary> The ISO8601 timestamp of the last device twin status update. </summary>
        public string StatusUpdateTime { get; }
        /// <summary> An integer that is incremented by one each time the device twin is updated. </summary>
        public float? Version { get; }
        /// <summary> The thumbprint is a unique value for the x509 certificate, commonly used to find a particular certificate in a certificate store. The thumbprint is dynamically generated using the SHA1 algorithm, and does not physically exist in the certificate. </summary>
        public DeviceTwinInfoX509Thumbprint X509Thumbprint { get; }
    }
}
