// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of DataBox Stage Name enumeration. </summary>
    public readonly partial struct DataBoxStageName : IEquatable<DataBoxStageName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxStageName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxStageName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CopyStartedValue = "CopyStarted";
        private const string CopyCompletedValue = "CopyCompleted";
        private const string OrderCompletedValue = "OrderCompleted";

        /// <summary> Copy has started. </summary>
        public static DataBoxStageName CopyStarted { get; } = new DataBoxStageName(CopyStartedValue);
        /// <summary> Copy has completed. </summary>
        public static DataBoxStageName CopyCompleted { get; } = new DataBoxStageName(CopyCompletedValue);
        /// <summary> Order has been completed. </summary>
        public static DataBoxStageName OrderCompleted { get; } = new DataBoxStageName(OrderCompletedValue);
        /// <summary> Determines if two <see cref="DataBoxStageName"/> values are the same. </summary>
        public static bool operator ==(DataBoxStageName left, DataBoxStageName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxStageName"/> values are not the same. </summary>
        public static bool operator !=(DataBoxStageName left, DataBoxStageName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxStageName"/>. </summary>
        public static implicit operator DataBoxStageName(string value) => new DataBoxStageName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxStageName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxStageName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
