// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.DataBox.CopyCompleted event. </summary>
    public partial class DataBoxCopyCompletedEventData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxCopyCompletedEventData"/>. </summary>
        /// <param name="stageName"> Name of the current Stage. </param>
        /// <param name="stageTime"> The time at which the stage happened. </param>
        internal DataBoxCopyCompletedEventData(DataBoxStageName stageName, DateTimeOffset stageTime)
        {
            StageName = stageName;
            StageTime = stageTime;
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxCopyCompletedEventData"/>. </summary>
        /// <param name="serialNumber"> Serial Number of the device associated with the event. The list is comma separated if more than one serial number is associated. </param>
        /// <param name="stageName"> Name of the current Stage. </param>
        /// <param name="stageTime"> The time at which the stage happened. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxCopyCompletedEventData(string serialNumber, DataBoxStageName stageName, DateTimeOffset stageTime, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SerialNumber = serialNumber;
            StageName = stageName;
            StageTime = stageTime;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxCopyCompletedEventData"/> for deserialization. </summary>
        internal DataBoxCopyCompletedEventData()
        {
        }

        /// <summary> Serial Number of the device associated with the event. The list is comma separated if more than one serial number is associated. </summary>
        public string SerialNumber { get; }
        /// <summary> Name of the current Stage. </summary>
        public DataBoxStageName StageName { get; }
        /// <summary> The time at which the stage happened. </summary>
        public DateTimeOffset StageTime { get; }
    }
}
