// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class ContainerServiceNewKubernetesVersionAvailableEventData : IUtf8JsonSerializable, IJsonModel<ContainerServiceNewKubernetesVersionAvailableEventData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ContainerServiceNewKubernetesVersionAvailableEventData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ContainerServiceNewKubernetesVersionAvailableEventData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerServiceNewKubernetesVersionAvailableEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerServiceNewKubernetesVersionAvailableEventData)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(LatestSupportedKubernetesVersion))
            {
                writer.WritePropertyName("latestSupportedKubernetesVersion"u8);
                writer.WriteStringValue(LatestSupportedKubernetesVersion);
            }
            if (Optional.IsDefined(LatestStableKubernetesVersion))
            {
                writer.WritePropertyName("latestStableKubernetesVersion"u8);
                writer.WriteStringValue(LatestStableKubernetesVersion);
            }
            if (Optional.IsDefined(LowestMinorKubernetesVersion))
            {
                writer.WritePropertyName("lowestMinorKubernetesVersion"u8);
                writer.WriteStringValue(LowestMinorKubernetesVersion);
            }
            if (Optional.IsDefined(LatestPreviewKubernetesVersion))
            {
                writer.WritePropertyName("latestPreviewKubernetesVersion"u8);
                writer.WriteStringValue(LatestPreviewKubernetesVersion);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ContainerServiceNewKubernetesVersionAvailableEventData IJsonModel<ContainerServiceNewKubernetesVersionAvailableEventData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerServiceNewKubernetesVersionAvailableEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerServiceNewKubernetesVersionAvailableEventData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeContainerServiceNewKubernetesVersionAvailableEventData(document.RootElement, options);
        }

        internal static ContainerServiceNewKubernetesVersionAvailableEventData DeserializeContainerServiceNewKubernetesVersionAvailableEventData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string latestSupportedKubernetesVersion = default;
            string latestStableKubernetesVersion = default;
            string lowestMinorKubernetesVersion = default;
            string latestPreviewKubernetesVersion = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("latestSupportedKubernetesVersion"u8))
                {
                    latestSupportedKubernetesVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("latestStableKubernetesVersion"u8))
                {
                    latestStableKubernetesVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lowestMinorKubernetesVersion"u8))
                {
                    lowestMinorKubernetesVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("latestPreviewKubernetesVersion"u8))
                {
                    latestPreviewKubernetesVersion = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ContainerServiceNewKubernetesVersionAvailableEventData(latestSupportedKubernetesVersion, latestStableKubernetesVersion, lowestMinorKubernetesVersion, latestPreviewKubernetesVersion, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ContainerServiceNewKubernetesVersionAvailableEventData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerServiceNewKubernetesVersionAvailableEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ContainerServiceNewKubernetesVersionAvailableEventData)} does not support writing '{options.Format}' format.");
            }
        }

        ContainerServiceNewKubernetesVersionAvailableEventData IPersistableModel<ContainerServiceNewKubernetesVersionAvailableEventData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerServiceNewKubernetesVersionAvailableEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeContainerServiceNewKubernetesVersionAvailableEventData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ContainerServiceNewKubernetesVersionAvailableEventData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ContainerServiceNewKubernetesVersionAvailableEventData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ContainerServiceNewKubernetesVersionAvailableEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeContainerServiceNewKubernetesVersionAvailableEventData(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
