// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> The target of the event. </summary>
    public partial class ContainerRegistryArtifactEventTarget
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryArtifactEventTarget"/>. </summary>
        internal ContainerRegistryArtifactEventTarget()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryArtifactEventTarget"/>. </summary>
        /// <param name="mediaType"> The MIME type of the artifact. </param>
        /// <param name="size"> The size in bytes of the artifact. </param>
        /// <param name="digest"> The digest of the artifact. </param>
        /// <param name="repository"> The repository name of the artifact. </param>
        /// <param name="tag"> The tag of the artifact. </param>
        /// <param name="name"> The name of the artifact. </param>
        /// <param name="version"> The version of the artifact. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerRegistryArtifactEventTarget(string mediaType, long? size, string digest, string repository, string tag, string name, string version, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MediaType = mediaType;
            Size = size;
            Digest = digest;
            Repository = repository;
            Tag = tag;
            Name = name;
            Version = version;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The MIME type of the artifact. </summary>
        public string MediaType { get; }
        /// <summary> The size in bytes of the artifact. </summary>
        public long? Size { get; }
        /// <summary> The digest of the artifact. </summary>
        public string Digest { get; }
        /// <summary> The repository name of the artifact. </summary>
        public string Repository { get; }
        /// <summary> The tag of the artifact. </summary>
        public string Tag { get; }
        /// <summary> The name of the artifact. </summary>
        public string Name { get; }
        /// <summary> The version of the artifact. </summary>
        public string Version { get; }
    }
}
