// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.AVS.ScriptExecutionFailed event. </summary>
    public partial class AvsScriptExecutionFailedEventData : AvsScriptExecutionEventData
    {
        /// <summary> Initializes a new instance of <see cref="AvsScriptExecutionFailedEventData"/>. </summary>
        internal AvsScriptExecutionFailedEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AvsScriptExecutionFailedEventData"/>. </summary>
        /// <param name="operationId"> Id of the operation that caused this event. </param>
        /// <param name="cmdletId"> Cmdlet referenced in the execution that caused this event. </param>
        /// <param name="output"> Stdout outputs from the execution, if any. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="failureMessage"> Failure reason of an event. </param>
        internal AvsScriptExecutionFailedEventData(string operationId, string cmdletId, IReadOnlyList<string> output, IDictionary<string, BinaryData> serializedAdditionalRawData, string failureMessage) : base(operationId, cmdletId, output, serializedAdditionalRawData)
        {
            FailureMessage = failureMessage;
        }

        /// <summary> Failure reason of an event. </summary>
        public string FailureMessage { get; }
    }
}
