// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.AVS.ClusterUpdating event. </summary>
    public partial class AvsClusterUpdatingEventData : AvsClusterEventData
    {
        /// <summary> Initializes a new instance of <see cref="AvsClusterUpdatingEventData"/>. </summary>
        internal AvsClusterUpdatingEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AvsClusterUpdatingEventData"/>. </summary>
        /// <param name="operationId"> Id of the operation that caused this event. </param>
        /// <param name="addedHostNames"> Hosts added to the cluster in this event, if any. </param>
        /// <param name="removedHostNames"> Hosts removed from the cluster in this event, if any. </param>
        /// <param name="inMaintenanceHostNames"> Hosts in Maintenance mode in the cluster, if any. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AvsClusterUpdatingEventData(string operationId, IReadOnlyList<string> addedHostNames, IReadOnlyList<string> removedHostNames, IReadOnlyList<string> inMaintenanceHostNames, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(operationId, addedHostNames, removedHostNames, inMaintenanceHostNames, serializedAdditionalRawData)
        {
        }
    }
}
