// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for Microsoft.AVS/clusters events. </summary>
    public partial class AvsClusterEventData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AvsClusterEventData"/>. </summary>
        internal AvsClusterEventData()
        {
            AddedHostNames = new ChangeTrackingList<string>();
            RemovedHostNames = new ChangeTrackingList<string>();
            InMaintenanceHostNames = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AvsClusterEventData"/>. </summary>
        /// <param name="operationId"> Id of the operation that caused this event. </param>
        /// <param name="addedHostNames"> Hosts added to the cluster in this event, if any. </param>
        /// <param name="removedHostNames"> Hosts removed from the cluster in this event, if any. </param>
        /// <param name="inMaintenanceHostNames"> Hosts in Maintenance mode in the cluster, if any. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AvsClusterEventData(string operationId, IReadOnlyList<string> addedHostNames, IReadOnlyList<string> removedHostNames, IReadOnlyList<string> inMaintenanceHostNames, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OperationId = operationId;
            AddedHostNames = addedHostNames;
            RemovedHostNames = removedHostNames;
            InMaintenanceHostNames = inMaintenanceHostNames;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Id of the operation that caused this event. </summary>
        public string OperationId { get; }
        /// <summary> Hosts added to the cluster in this event, if any. </summary>
        public IReadOnlyList<string> AddedHostNames { get; }
        /// <summary> Hosts removed from the cluster in this event, if any. </summary>
        public IReadOnlyList<string> RemovedHostNames { get; }
        /// <summary> Hosts in Maintenance mode in the cluster, if any. </summary>
        public IReadOnlyList<string> InMaintenanceHostNames { get; }
    }
}
