// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Detail of action on the app service plan. </summary>
    public partial class AppServicePlanEventTypeDetail
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppServicePlanEventTypeDetail"/>. </summary>
        /// <param name="stampKind"> Kind of environment where app service plan is. </param>
        /// <param name="action"> Type of action on the app service plan. </param>
        /// <param name="status"> Asynchronous operation status of the operation on the app service plan. </param>
        internal AppServicePlanEventTypeDetail(StampKind stampKind, AppServicePlanAction action, AsyncStatus status)
        {
            StampKind = stampKind;
            Action = action;
            Status = status;
        }

        /// <summary> Initializes a new instance of <see cref="AppServicePlanEventTypeDetail"/>. </summary>
        /// <param name="stampKind"> Kind of environment where app service plan is. </param>
        /// <param name="action"> Type of action on the app service plan. </param>
        /// <param name="status"> Asynchronous operation status of the operation on the app service plan. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppServicePlanEventTypeDetail(StampKind stampKind, AppServicePlanAction action, AsyncStatus status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StampKind = stampKind;
            Action = action;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AppServicePlanEventTypeDetail"/> for deserialization. </summary>
        internal AppServicePlanEventTypeDetail()
        {
        }

        /// <summary> Kind of environment where app service plan is. </summary>
        public StampKind StampKind { get; }
        /// <summary> Type of action on the app service plan. </summary>
        public AppServicePlanAction Action { get; }
        /// <summary> Asynchronous operation status of the operation on the app service plan. </summary>
        public AsyncStatus Status { get; }
    }
}
