// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Type of action on the app service plan. </summary>
    public readonly partial struct AppServicePlanAction : IEquatable<AppServicePlanAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppServicePlanAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppServicePlanAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UpdatedValue = "Updated";

        /// <summary> App Service plan is being updated. </summary>
        public static AppServicePlanAction Updated { get; } = new AppServicePlanAction(UpdatedValue);
        /// <summary> Determines if two <see cref="AppServicePlanAction"/> values are the same. </summary>
        public static bool operator ==(AppServicePlanAction left, AppServicePlanAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppServicePlanAction"/> values are not the same. </summary>
        public static bool operator !=(AppServicePlanAction left, AppServicePlanAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppServicePlanAction"/>. </summary>
        public static implicit operator AppServicePlanAction(string value) => new AppServicePlanAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppServicePlanAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppServicePlanAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
