// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.AppConfiguration.KeyValueModified event. </summary>
    public partial class AppConfigurationKeyValueModifiedEventData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppConfigurationKeyValueModifiedEventData"/>. </summary>
        internal AppConfigurationKeyValueModifiedEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AppConfigurationKeyValueModifiedEventData"/>. </summary>
        /// <param name="key"> The key used to identify the key-value that was modified. </param>
        /// <param name="label"> The label, if any, used to identify the key-value that was modified. </param>
        /// <param name="etag"> The etag representing the new state of the key-value. </param>
        /// <param name="syncToken"> The sync token representing the server state after the event. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppConfigurationKeyValueModifiedEventData(string key, string label, string etag, string syncToken, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Key = key;
            Label = label;
            Etag = etag;
            SyncToken = syncToken;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The key used to identify the key-value that was modified. </summary>
        public string Key { get; }
        /// <summary> The label, if any, used to identify the key-value that was modified. </summary>
        public string Label { get; }
        /// <summary> The etag representing the new state of the key-value. </summary>
        public string Etag { get; }
        /// <summary> The sync token representing the server state after the event. </summary>
        public string SyncToken { get; }
    }
}
