// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the data property of an EventGridEvent for a Microsoft.ApiCenter.ApiDefinitionUpdated event. </summary>
    public partial class ApiCenterApiDefinitionUpdatedEventData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApiCenterApiDefinitionUpdatedEventData"/>. </summary>
        /// <param name="specification"> API definition specification. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="specification"/> is null. </exception>
        internal ApiCenterApiDefinitionUpdatedEventData(ApiCenterApiSpecification specification)
        {
            Argument.AssertNotNull(specification, nameof(specification));

            Specification = specification;
        }

        /// <summary> Initializes a new instance of <see cref="ApiCenterApiDefinitionUpdatedEventData"/>. </summary>
        /// <param name="title"> API definition title. </param>
        /// <param name="description"> API definition description. </param>
        /// <param name="specification"> API definition specification. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApiCenterApiDefinitionUpdatedEventData(string title, string description, ApiCenterApiSpecification specification, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Title = title;
            Description = description;
            Specification = specification;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ApiCenterApiDefinitionUpdatedEventData"/> for deserialization. </summary>
        internal ApiCenterApiDefinitionUpdatedEventData()
        {
        }

        /// <summary> API definition title. </summary>
        public string Title { get; }
        /// <summary> API definition description. </summary>
        public string Description { get; }
        /// <summary> API definition specification. </summary>
        public ApiCenterApiSpecification Specification { get; }
    }
}
