// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class AcsSmsDeliveryReportReceivedEventData : IUtf8JsonSerializable, IJsonModel<AcsSmsDeliveryReportReceivedEventData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AcsSmsDeliveryReportReceivedEventData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AcsSmsDeliveryReportReceivedEventData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsSmsDeliveryReportReceivedEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AcsSmsDeliveryReportReceivedEventData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(DeliveryStatus))
            {
                writer.WritePropertyName("deliveryStatus"u8);
                writer.WriteStringValue(DeliveryStatus);
            }
            if (Optional.IsDefined(DeliveryStatusDetails))
            {
                writer.WritePropertyName("deliveryStatusDetails"u8);
                writer.WriteStringValue(DeliveryStatusDetails);
            }
            writer.WritePropertyName("deliveryAttempts"u8);
            writer.WriteStartArray();
            foreach (var item in DeliveryAttempts)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("receivedTimestamp"u8);
            writer.WriteStringValue(ReceivedTimestamp, "O");
            if (Optional.IsDefined(Tag))
            {
                writer.WritePropertyName("tag"u8);
                writer.WriteStringValue(Tag);
            }
        }

        AcsSmsDeliveryReportReceivedEventData IJsonModel<AcsSmsDeliveryReportReceivedEventData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsSmsDeliveryReportReceivedEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AcsSmsDeliveryReportReceivedEventData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAcsSmsDeliveryReportReceivedEventData(document.RootElement, options);
        }

        internal static AcsSmsDeliveryReportReceivedEventData DeserializeAcsSmsDeliveryReportReceivedEventData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string deliveryStatus = default;
            string deliveryStatusDetails = default;
            IReadOnlyList<AcsSmsDeliveryAttemptProperties> deliveryAttempts = default;
            DateTimeOffset receivedTimestamp = default;
            string tag = default;
            string messageId = default;
            string @from = default;
            string to = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("deliveryStatus"u8))
                {
                    deliveryStatus = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("deliveryStatusDetails"u8))
                {
                    deliveryStatusDetails = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("deliveryAttempts"u8))
                {
                    List<AcsSmsDeliveryAttemptProperties> array = new List<AcsSmsDeliveryAttemptProperties>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AcsSmsDeliveryAttemptProperties.DeserializeAcsSmsDeliveryAttemptProperties(item, options));
                    }
                    deliveryAttempts = array;
                    continue;
                }
                if (property.NameEquals("receivedTimestamp"u8))
                {
                    receivedTimestamp = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("tag"u8))
                {
                    tag = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("messageId"u8))
                {
                    messageId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("from"u8))
                {
                    @from = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("to"u8))
                {
                    to = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AcsSmsDeliveryReportReceivedEventData(
                messageId,
                @from,
                to,
                serializedAdditionalRawData,
                deliveryStatus,
                deliveryStatusDetails,
                deliveryAttempts,
                receivedTimestamp,
                tag);
        }

        BinaryData IPersistableModel<AcsSmsDeliveryReportReceivedEventData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsSmsDeliveryReportReceivedEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AcsSmsDeliveryReportReceivedEventData)} does not support writing '{options.Format}' format.");
            }
        }

        AcsSmsDeliveryReportReceivedEventData IPersistableModel<AcsSmsDeliveryReportReceivedEventData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsSmsDeliveryReportReceivedEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAcsSmsDeliveryReportReceivedEventData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AcsSmsDeliveryReportReceivedEventData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AcsSmsDeliveryReportReceivedEventData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new AcsSmsDeliveryReportReceivedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsSmsDeliveryReportReceivedEventData(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal override RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
