// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterWorkerOfferDeclined event. </summary>
    public partial class AcsRouterWorkerOfferDeclinedEventData : AcsRouterWorkerEventData
    {
        /// <summary> Initializes a new instance of <see cref="AcsRouterWorkerOfferDeclinedEventData"/>. </summary>
        internal AcsRouterWorkerOfferDeclinedEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AcsRouterWorkerOfferDeclinedEventData"/>. </summary>
        /// <param name="jobId"> Router Event Job ID. </param>
        /// <param name="channelReference"> Router Event Channel Reference. </param>
        /// <param name="channelId"> Router Event Channel ID. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="workerId"> Router Worker events Worker Id. </param>
        /// <param name="queueId"> Router Worker Offer Declined Queue Id. </param>
        /// <param name="offerId"> Router Worker Offer Declined Offer Id. </param>
        internal AcsRouterWorkerOfferDeclinedEventData(string jobId, string channelReference, string channelId, IDictionary<string, BinaryData> serializedAdditionalRawData, string workerId, string queueId, string offerId) : base(jobId, channelReference, channelId, serializedAdditionalRawData, workerId)
        {
            QueueId = queueId;
            OfferId = offerId;
        }

        /// <summary> Router Worker Offer Declined Queue Id. </summary>
        public string QueueId { get; }
        /// <summary> Router Worker Offer Declined Offer Id. </summary>
        public string OfferId { get; }
    }
}
