// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Worker properties that can be updated. </summary>
    public readonly partial struct AcsRouterUpdatedWorkerProperty : IEquatable<AcsRouterUpdatedWorkerProperty>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AcsRouterUpdatedWorkerProperty"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AcsRouterUpdatedWorkerProperty(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AvailableForOffersValue = "AvailableForOffers";
        private const string TotalCapacityValue = "TotalCapacity";
        private const string QueueAssignmentsValue = "QueueAssignments";
        private const string LabelsValue = "Labels";
        private const string TagsValue = "Tags";
        private const string ChannelConfigurationsValue = "ChannelConfigurations";

        /// <summary> AvailableForOffers. </summary>
        public static AcsRouterUpdatedWorkerProperty AvailableForOffers { get; } = new AcsRouterUpdatedWorkerProperty(AvailableForOffersValue);
        /// <summary> TotalCapacity. </summary>
        public static AcsRouterUpdatedWorkerProperty TotalCapacity { get; } = new AcsRouterUpdatedWorkerProperty(TotalCapacityValue);
        /// <summary> QueueAssignments. </summary>
        public static AcsRouterUpdatedWorkerProperty QueueAssignments { get; } = new AcsRouterUpdatedWorkerProperty(QueueAssignmentsValue);
        /// <summary> Labels. </summary>
        public static AcsRouterUpdatedWorkerProperty Labels { get; } = new AcsRouterUpdatedWorkerProperty(LabelsValue);
        /// <summary> Tags. </summary>
        public static AcsRouterUpdatedWorkerProperty Tags { get; } = new AcsRouterUpdatedWorkerProperty(TagsValue);
        /// <summary> ChannelConfigurations. </summary>
        public static AcsRouterUpdatedWorkerProperty ChannelConfigurations { get; } = new AcsRouterUpdatedWorkerProperty(ChannelConfigurationsValue);
        /// <summary> Determines if two <see cref="AcsRouterUpdatedWorkerProperty"/> values are the same. </summary>
        public static bool operator ==(AcsRouterUpdatedWorkerProperty left, AcsRouterUpdatedWorkerProperty right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AcsRouterUpdatedWorkerProperty"/> values are not the same. </summary>
        public static bool operator !=(AcsRouterUpdatedWorkerProperty left, AcsRouterUpdatedWorkerProperty right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AcsRouterUpdatedWorkerProperty"/>. </summary>
        public static implicit operator AcsRouterUpdatedWorkerProperty(string value) => new AcsRouterUpdatedWorkerProperty(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AcsRouterUpdatedWorkerProperty other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AcsRouterUpdatedWorkerProperty other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
