// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Router Queue Details. </summary>
    public partial class AcsRouterQueueDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AcsRouterQueueDetails"/>. </summary>
        /// <param name="labels"> Router Queue Labels. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="labels"/> is null. </exception>
        internal AcsRouterQueueDetails(IReadOnlyDictionary<string, string> labels)
        {
            Argument.AssertNotNull(labels, nameof(labels));

            Labels = labels;
        }

        /// <summary> Initializes a new instance of <see cref="AcsRouterQueueDetails"/>. </summary>
        /// <param name="id"> Router Queue Id. </param>
        /// <param name="name"> Router Queue Name. </param>
        /// <param name="labels"> Router Queue Labels. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AcsRouterQueueDetails(string id, string name, IReadOnlyDictionary<string, string> labels, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Name = name;
            Labels = labels;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AcsRouterQueueDetails"/> for deserialization. </summary>
        internal AcsRouterQueueDetails()
        {
        }

        /// <summary> Router Queue Id. </summary>
        public string Id { get; }
        /// <summary> Router Queue Name. </summary>
        public string Name { get; }
        /// <summary> Router Queue Labels. </summary>
        public IReadOnlyDictionary<string, string> Labels { get; }
    }
}
