// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterJobUnassigned event. </summary>
    public partial class AcsRouterJobUnassignedEventData : AcsRouterJobEventData
    {
        /// <summary> Initializes a new instance of <see cref="AcsRouterJobUnassignedEventData"/>. </summary>
        /// <param name="labels"> Router Job events Labels. </param>
        /// <param name="tags"> Router Jobs events Tags. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="labels"/> or <paramref name="tags"/> is null. </exception>
        internal AcsRouterJobUnassignedEventData(IReadOnlyDictionary<string, string> labels, IReadOnlyDictionary<string, string> tags) : base(labels, tags)
        {
            Argument.AssertNotNull(labels, nameof(labels));
            Argument.AssertNotNull(tags, nameof(tags));
        }

        /// <summary> Initializes a new instance of <see cref="AcsRouterJobUnassignedEventData"/>. </summary>
        /// <param name="jobId"> Router Event Job ID. </param>
        /// <param name="channelReference"> Router Event Channel Reference. </param>
        /// <param name="channelId"> Router Event Channel ID. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="queueId"> Router Job events Queue Id. </param>
        /// <param name="labels"> Router Job events Labels. </param>
        /// <param name="tags"> Router Jobs events Tags. </param>
        /// <param name="assignmentId"> Router Job Unassigned Assignment Id. </param>
        /// <param name="workerId"> Router Job Unassigned Worker Id. </param>
        internal AcsRouterJobUnassignedEventData(string jobId, string channelReference, string channelId, IDictionary<string, BinaryData> serializedAdditionalRawData, string queueId, IReadOnlyDictionary<string, string> labels, IReadOnlyDictionary<string, string> tags, string assignmentId, string workerId) : base(jobId, channelReference, channelId, serializedAdditionalRawData, queueId, labels, tags)
        {
            AssignmentId = assignmentId;
            WorkerId = workerId;
        }

        /// <summary> Initializes a new instance of <see cref="AcsRouterJobUnassignedEventData"/> for deserialization. </summary>
        internal AcsRouterJobUnassignedEventData()
        {
        }

        /// <summary> Router Job Unassigned Assignment Id. </summary>
        public string AssignmentId { get; }
        /// <summary> Router Job Unassigned Worker Id. </summary>
        public string WorkerId { get; }
    }
}
