// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterJobReceived event. </summary>
    public partial class AcsRouterJobReceivedEventData : AcsRouterJobEventData
    {
        /// <summary> Initializes a new instance of <see cref="AcsRouterJobReceivedEventData"/>. </summary>
        /// <param name="labels"> Router Job events Labels. </param>
        /// <param name="tags"> Router Jobs events Tags. </param>
        /// <param name="jobStatus"> Router Job Received Job Status. </param>
        /// <param name="requestedWorkerSelectors"> Router Job Received Requested Worker Selectors. </param>
        /// <param name="scheduledOn"> Router Job Received Scheduled Time in UTC. </param>
        /// <param name="unavailableForMatching"> Unavailable For Matching for Router Job Received. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="labels"/>, <paramref name="tags"/> or <paramref name="requestedWorkerSelectors"/> is null. </exception>
        internal AcsRouterJobReceivedEventData(IReadOnlyDictionary<string, string> labels, IReadOnlyDictionary<string, string> tags, AcsRouterJobStatus jobStatus, IEnumerable<AcsRouterWorkerSelector> requestedWorkerSelectors, DateTimeOffset scheduledOn, bool unavailableForMatching) : base(labels, tags)
        {
            Argument.AssertNotNull(labels, nameof(labels));
            Argument.AssertNotNull(tags, nameof(tags));
            Argument.AssertNotNull(requestedWorkerSelectors, nameof(requestedWorkerSelectors));

            JobStatus = jobStatus;
            RequestedWorkerSelectors = requestedWorkerSelectors.ToList();
            ScheduledOn = scheduledOn;
            UnavailableForMatching = unavailableForMatching;
        }

        /// <summary> Initializes a new instance of <see cref="AcsRouterJobReceivedEventData"/>. </summary>
        /// <param name="jobId"> Router Event Job ID. </param>
        /// <param name="channelReference"> Router Event Channel Reference. </param>
        /// <param name="channelId"> Router Event Channel ID. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="queueId"> Router Job events Queue Id. </param>
        /// <param name="labels"> Router Job events Labels. </param>
        /// <param name="tags"> Router Jobs events Tags. </param>
        /// <param name="jobStatus"> Router Job Received Job Status. </param>
        /// <param name="classificationPolicyId"> Router Job Classification Policy Id. </param>
        /// <param name="priority"> Router Job Priority. </param>
        /// <param name="requestedWorkerSelectors"> Router Job Received Requested Worker Selectors. </param>
        /// <param name="scheduledOn"> Router Job Received Scheduled Time in UTC. </param>
        /// <param name="unavailableForMatching"> Unavailable For Matching for Router Job Received. </param>
        internal AcsRouterJobReceivedEventData(string jobId, string channelReference, string channelId, IDictionary<string, BinaryData> serializedAdditionalRawData, string queueId, IReadOnlyDictionary<string, string> labels, IReadOnlyDictionary<string, string> tags, AcsRouterJobStatus jobStatus, string classificationPolicyId, int? priority, IReadOnlyList<AcsRouterWorkerSelector> requestedWorkerSelectors, DateTimeOffset scheduledOn, bool unavailableForMatching) : base(jobId, channelReference, channelId, serializedAdditionalRawData, queueId, labels, tags)
        {
            JobStatus = jobStatus;
            ClassificationPolicyId = classificationPolicyId;
            Priority = priority;
            RequestedWorkerSelectors = requestedWorkerSelectors;
            ScheduledOn = scheduledOn;
            UnavailableForMatching = unavailableForMatching;
        }

        /// <summary> Initializes a new instance of <see cref="AcsRouterJobReceivedEventData"/> for deserialization. </summary>
        internal AcsRouterJobReceivedEventData()
        {
        }

        /// <summary> Router Job Received Job Status. </summary>
        public AcsRouterJobStatus JobStatus { get; }
        /// <summary> Router Job Classification Policy Id. </summary>
        public string ClassificationPolicyId { get; }
        /// <summary> Router Job Priority. </summary>
        public int? Priority { get; }
        /// <summary> Router Job Received Requested Worker Selectors. </summary>
        public IReadOnlyList<AcsRouterWorkerSelector> RequestedWorkerSelectors { get; }
        /// <summary> Router Job Received Scheduled Time in UTC. </summary>
        public DateTimeOffset ScheduledOn { get; }
        /// <summary> Unavailable For Matching for Router Job Received. </summary>
        public bool UnavailableForMatching { get; }
    }
}
