// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterJobClosed event. </summary>
    public partial class AcsRouterJobClosedEventData : AcsRouterJobEventData
    {
        /// <summary> Initializes a new instance of <see cref="AcsRouterJobClosedEventData"/>. </summary>
        /// <param name="labels"> Router Job events Labels. </param>
        /// <param name="tags"> Router Jobs events Tags. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="labels"/> or <paramref name="tags"/> is null. </exception>
        internal AcsRouterJobClosedEventData(IReadOnlyDictionary<string, string> labels, IReadOnlyDictionary<string, string> tags) : base(labels, tags)
        {
            Argument.AssertNotNull(labels, nameof(labels));
            Argument.AssertNotNull(tags, nameof(tags));
        }

        /// <summary> Initializes a new instance of <see cref="AcsRouterJobClosedEventData"/>. </summary>
        /// <param name="jobId"> Router Event Job ID. </param>
        /// <param name="channelReference"> Router Event Channel Reference. </param>
        /// <param name="channelId"> Router Event Channel ID. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="queueId"> Router Job events Queue Id. </param>
        /// <param name="labels"> Router Job events Labels. </param>
        /// <param name="tags"> Router Jobs events Tags. </param>
        /// <param name="assignmentId"> Router Job Closed Assignment Id. </param>
        /// <param name="workerId"> Router Job Closed Worker Id. </param>
        /// <param name="dispositionCode"> Router Job Closed Disposition Code. </param>
        internal AcsRouterJobClosedEventData(string jobId, string channelReference, string channelId, IDictionary<string, BinaryData> serializedAdditionalRawData, string queueId, IReadOnlyDictionary<string, string> labels, IReadOnlyDictionary<string, string> tags, string assignmentId, string workerId, string dispositionCode) : base(jobId, channelReference, channelId, serializedAdditionalRawData, queueId, labels, tags)
        {
            AssignmentId = assignmentId;
            WorkerId = workerId;
            DispositionCode = dispositionCode;
        }

        /// <summary> Initializes a new instance of <see cref="AcsRouterJobClosedEventData"/> for deserialization. </summary>
        internal AcsRouterJobClosedEventData()
        {
        }

        /// <summary> Router Job Closed Assignment Id. </summary>
        public string AssignmentId { get; }
        /// <summary> Router Job Closed Worker Id. </summary>
        public string WorkerId { get; }
        /// <summary> Router Job Closed Disposition Code. </summary>
        public string DispositionCode { get; }
    }
}
