// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class AcsRecordingFileStatusUpdatedEventData : IUtf8JsonSerializable, IJsonModel<AcsRecordingFileStatusUpdatedEventData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AcsRecordingFileStatusUpdatedEventData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AcsRecordingFileStatusUpdatedEventData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsRecordingFileStatusUpdatedEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AcsRecordingFileStatusUpdatedEventData)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("recordingStorageInfo"u8);
            writer.WriteObjectValue(RecordingStorageInfo, options);
            writer.WritePropertyName("recordingStartTime"u8);
            writer.WriteStringValue(RecordingStartTime, "O");
            if (Optional.IsDefined(RecordingDurationMs))
            {
                writer.WritePropertyName("recordingDurationMs"u8);
                writer.WriteNumberValue(RecordingDurationMs.Value);
            }
            writer.WritePropertyName("recordingContentType"u8);
            writer.WriteStringValue(RecordingContentType.ToString());
            writer.WritePropertyName("recordingChannelType"u8);
            writer.WriteStringValue(RecordingChannelKind.ToString());
            writer.WritePropertyName("recordingFormatType"u8);
            writer.WriteStringValue(RecordingFormatType.ToString());
            if (Optional.IsDefined(SessionEndReason))
            {
                writer.WritePropertyName("sessionEndReason"u8);
                writer.WriteStringValue(SessionEndReason);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AcsRecordingFileStatusUpdatedEventData IJsonModel<AcsRecordingFileStatusUpdatedEventData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsRecordingFileStatusUpdatedEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AcsRecordingFileStatusUpdatedEventData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAcsRecordingFileStatusUpdatedEventData(document.RootElement, options);
        }

        internal static AcsRecordingFileStatusUpdatedEventData DeserializeAcsRecordingFileStatusUpdatedEventData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AcsRecordingStorageInfoProperties recordingStorageInfo = default;
            DateTimeOffset recordingStartTime = default;
            long? recordingDurationMs = default;
            RecordingContentType recordingContentType = default;
            RecordingChannelType recordingChannelType = default;
            RecordingFormatType recordingFormatType = default;
            string sessionEndReason = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("recordingStorageInfo"u8))
                {
                    recordingStorageInfo = AcsRecordingStorageInfoProperties.DeserializeAcsRecordingStorageInfoProperties(property.Value, options);
                    continue;
                }
                if (property.NameEquals("recordingStartTime"u8))
                {
                    recordingStartTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("recordingDurationMs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recordingDurationMs = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("recordingContentType"u8))
                {
                    recordingContentType = new RecordingContentType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("recordingChannelType"u8))
                {
                    recordingChannelType = new RecordingChannelType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("recordingFormatType"u8))
                {
                    recordingFormatType = new RecordingFormatType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("sessionEndReason"u8))
                {
                    sessionEndReason = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AcsRecordingFileStatusUpdatedEventData(
                recordingStorageInfo,
                recordingStartTime,
                recordingDurationMs,
                recordingContentType,
                recordingChannelType,
                recordingFormatType,
                sessionEndReason,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AcsRecordingFileStatusUpdatedEventData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsRecordingFileStatusUpdatedEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AcsRecordingFileStatusUpdatedEventData)} does not support writing '{options.Format}' format.");
            }
        }

        AcsRecordingFileStatusUpdatedEventData IPersistableModel<AcsRecordingFileStatusUpdatedEventData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsRecordingFileStatusUpdatedEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAcsRecordingFileStatusUpdatedEventData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AcsRecordingFileStatusUpdatedEventData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AcsRecordingFileStatusUpdatedEventData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcsRecordingFileStatusUpdatedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsRecordingFileStatusUpdatedEventData(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
