// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class AcsRecordingChunkInfoProperties : IUtf8JsonSerializable, IJsonModel<AcsRecordingChunkInfoProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AcsRecordingChunkInfoProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AcsRecordingChunkInfoProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsRecordingChunkInfoProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AcsRecordingChunkInfoProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(DocumentId))
            {
                writer.WritePropertyName("documentId"u8);
                writer.WriteStringValue(DocumentId);
            }
            if (Optional.IsDefined(Index))
            {
                writer.WritePropertyName("index"u8);
                writer.WriteNumberValue(Index.Value);
            }
            if (Optional.IsDefined(EndReason))
            {
                writer.WritePropertyName("endReason"u8);
                writer.WriteStringValue(EndReason);
            }
            if (Optional.IsDefined(MetadataLocation))
            {
                writer.WritePropertyName("metadataLocation"u8);
                writer.WriteStringValue(MetadataLocation);
            }
            if (Optional.IsDefined(ContentLocation))
            {
                writer.WritePropertyName("contentLocation"u8);
                writer.WriteStringValue(ContentLocation);
            }
            if (Optional.IsDefined(DeleteLocation))
            {
                writer.WritePropertyName("deleteLocation"u8);
                writer.WriteStringValue(DeleteLocation);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AcsRecordingChunkInfoProperties IJsonModel<AcsRecordingChunkInfoProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsRecordingChunkInfoProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AcsRecordingChunkInfoProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAcsRecordingChunkInfoProperties(document.RootElement, options);
        }

        internal static AcsRecordingChunkInfoProperties DeserializeAcsRecordingChunkInfoProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string documentId = default;
            long? index = default;
            string endReason = default;
            string metadataLocation = default;
            string contentLocation = default;
            string deleteLocation = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("documentId"u8))
                {
                    documentId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("index"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    index = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("endReason"u8))
                {
                    endReason = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("metadataLocation"u8))
                {
                    metadataLocation = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("contentLocation"u8))
                {
                    contentLocation = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("deleteLocation"u8))
                {
                    deleteLocation = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AcsRecordingChunkInfoProperties(
                documentId,
                index,
                endReason,
                metadataLocation,
                contentLocation,
                deleteLocation,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AcsRecordingChunkInfoProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsRecordingChunkInfoProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AcsRecordingChunkInfoProperties)} does not support writing '{options.Format}' format.");
            }
        }

        AcsRecordingChunkInfoProperties IPersistableModel<AcsRecordingChunkInfoProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsRecordingChunkInfoProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAcsRecordingChunkInfoProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AcsRecordingChunkInfoProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AcsRecordingChunkInfoProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcsRecordingChunkInfoProperties FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsRecordingChunkInfoProperties(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
