// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class AcsMessageReceivedEventData : IUtf8JsonSerializable, IJsonModel<AcsMessageReceivedEventData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AcsMessageReceivedEventData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AcsMessageReceivedEventData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsMessageReceivedEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AcsMessageReceivedEventData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(Content))
            {
                writer.WritePropertyName("content"u8);
                writer.WriteStringValue(Content);
            }
            writer.WritePropertyName("channelType"u8);
            writer.WriteStringValue(ChannelKind.ToString());
            writer.WritePropertyName("media"u8);
            writer.WriteObjectValue(MediaContent, options);
            writer.WritePropertyName("context"u8);
            writer.WriteObjectValue(Context, options);
            writer.WritePropertyName("button"u8);
            writer.WriteObjectValue(Button, options);
            writer.WritePropertyName("interactive"u8);
            writer.WriteObjectValue(InteractiveContent, options);
        }

        AcsMessageReceivedEventData IJsonModel<AcsMessageReceivedEventData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsMessageReceivedEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AcsMessageReceivedEventData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAcsMessageReceivedEventData(document.RootElement, options);
        }

        internal static AcsMessageReceivedEventData DeserializeAcsMessageReceivedEventData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string content = default;
            AcsMessageChannelKind channelType = default;
            AcsMessageMediaContent media = default;
            AcsMessageContext context = default;
            AcsMessageButtonContent button = default;
            AcsMessageInteractiveContent interactive = default;
            string @from = default;
            string to = default;
            DateTimeOffset receivedTimeStamp = default;
            AcsMessageChannelEventError error = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("content"u8))
                {
                    content = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("channelType"u8))
                {
                    channelType = new AcsMessageChannelKind(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("media"u8))
                {
                    media = AcsMessageMediaContent.DeserializeAcsMessageMediaContent(property.Value, options);
                    continue;
                }
                if (property.NameEquals("context"u8))
                {
                    context = AcsMessageContext.DeserializeAcsMessageContext(property.Value, options);
                    continue;
                }
                if (property.NameEquals("button"u8))
                {
                    button = AcsMessageButtonContent.DeserializeAcsMessageButtonContent(property.Value, options);
                    continue;
                }
                if (property.NameEquals("interactive"u8))
                {
                    interactive = AcsMessageInteractiveContent.DeserializeAcsMessageInteractiveContent(property.Value, options);
                    continue;
                }
                if (property.NameEquals("from"u8))
                {
                    @from = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("to"u8))
                {
                    to = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("receivedTimeStamp"u8))
                {
                    receivedTimeStamp = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("error"u8))
                {
                    error = AcsMessageChannelEventError.DeserializeAcsMessageChannelEventError(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AcsMessageReceivedEventData(
                @from,
                to,
                receivedTimeStamp,
                error,
                serializedAdditionalRawData,
                content,
                channelType,
                media,
                context,
                button,
                interactive);
        }

        BinaryData IPersistableModel<AcsMessageReceivedEventData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsMessageReceivedEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AcsMessageReceivedEventData)} does not support writing '{options.Format}' format.");
            }
        }

        AcsMessageReceivedEventData IPersistableModel<AcsMessageReceivedEventData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsMessageReceivedEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAcsMessageReceivedEventData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AcsMessageReceivedEventData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AcsMessageReceivedEventData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new AcsMessageReceivedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsMessageReceivedEventData(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal override RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
