// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Message delivery status. </summary>
    public readonly partial struct AcsMessageDeliveryStatus : IEquatable<AcsMessageDeliveryStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AcsMessageDeliveryStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AcsMessageDeliveryStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ReadValue = "read";
        private const string DeliveredValue = "delivered";
        private const string FailedValue = "failed";
        private const string SentValue = "sent";
        private const string WarningValue = "warning";
        private const string UnknownValue = "unknown";

        /// <summary> Read. </summary>
        public static AcsMessageDeliveryStatus Read { get; } = new AcsMessageDeliveryStatus(ReadValue);
        /// <summary> Delivered. </summary>
        public static AcsMessageDeliveryStatus Delivered { get; } = new AcsMessageDeliveryStatus(DeliveredValue);
        /// <summary> Failed. </summary>
        public static AcsMessageDeliveryStatus Failed { get; } = new AcsMessageDeliveryStatus(FailedValue);
        /// <summary> Sent. </summary>
        public static AcsMessageDeliveryStatus Sent { get; } = new AcsMessageDeliveryStatus(SentValue);
        /// <summary> Warning. </summary>
        public static AcsMessageDeliveryStatus Warning { get; } = new AcsMessageDeliveryStatus(WarningValue);
        /// <summary> Unknown. </summary>
        public static AcsMessageDeliveryStatus Unknown { get; } = new AcsMessageDeliveryStatus(UnknownValue);
        /// <summary> Determines if two <see cref="AcsMessageDeliveryStatus"/> values are the same. </summary>
        public static bool operator ==(AcsMessageDeliveryStatus left, AcsMessageDeliveryStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AcsMessageDeliveryStatus"/> values are not the same. </summary>
        public static bool operator !=(AcsMessageDeliveryStatus left, AcsMessageDeliveryStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AcsMessageDeliveryStatus"/>. </summary>
        public static implicit operator AcsMessageDeliveryStatus(string value) => new AcsMessageDeliveryStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AcsMessageDeliveryStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AcsMessageDeliveryStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
