// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Message channel kind. </summary>
    public readonly partial struct AcsMessageChannelKind : IEquatable<AcsMessageChannelKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AcsMessageChannelKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AcsMessageChannelKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WhatsappValue = "whatsapp";

        /// <summary> Updated message channel type is WhatsApp. </summary>
        public static AcsMessageChannelKind Whatsapp { get; } = new AcsMessageChannelKind(WhatsappValue);
        /// <summary> Determines if two <see cref="AcsMessageChannelKind"/> values are the same. </summary>
        public static bool operator ==(AcsMessageChannelKind left, AcsMessageChannelKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AcsMessageChannelKind"/> values are not the same. </summary>
        public static bool operator !=(AcsMessageChannelKind left, AcsMessageChannelKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AcsMessageChannelKind"/>. </summary>
        public static implicit operator AcsMessageChannelKind(string value) => new AcsMessageChannelKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AcsMessageChannelKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AcsMessageChannelKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
