// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Message Channel Event Error. </summary>
    public partial class AcsMessageChannelEventError
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AcsMessageChannelEventError"/>. </summary>
        internal AcsMessageChannelEventError()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AcsMessageChannelEventError"/>. </summary>
        /// <param name="channelCode"> The channel error code. </param>
        /// <param name="channelMessage"> The channel error message. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AcsMessageChannelEventError(string channelCode, string channelMessage, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ChannelCode = channelCode;
            ChannelMessage = channelMessage;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The channel error code. </summary>
        public string ChannelCode { get; }
        /// <summary> The channel error message. </summary>
        public string ChannelMessage { get; }
    }
}
