// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Message Button Content. </summary>
    public partial class AcsMessageButtonContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AcsMessageButtonContent"/>. </summary>
        internal AcsMessageButtonContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AcsMessageButtonContent"/>. </summary>
        /// <param name="text"> The Text of the button. </param>
        /// <param name="payload"> The Payload of the button which was clicked by the user, setup by the business. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AcsMessageButtonContent(string text, string payload, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Text = text;
            Payload = payload;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Text of the button. </summary>
        public string Text { get; }
        /// <summary> The Payload of the button which was clicked by the user, setup by the business. </summary>
        public string Payload { get; }
    }
}
