// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for an Microsoft.Communication.IncomingCall event. </summary>
    public partial class AcsIncomingCallEventData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AcsIncomingCallEventData"/>. </summary>
        /// <param name="toCommunicationIdentifier"> The communication identifier of the target user. </param>
        /// <param name="fromCommunicationIdentifier"> The communication identifier of the user who initiated the call. </param>
        /// <param name="customContext"> Custom Context of Incoming Call. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="toCommunicationIdentifier"/>, <paramref name="fromCommunicationIdentifier"/> or <paramref name="customContext"/> is null. </exception>
        internal AcsIncomingCallEventData(CommunicationIdentifierModel toCommunicationIdentifier, CommunicationIdentifierModel fromCommunicationIdentifier, AcsIncomingCallCustomContext customContext)
        {
            Argument.AssertNotNull(toCommunicationIdentifier, nameof(toCommunicationIdentifier));
            Argument.AssertNotNull(fromCommunicationIdentifier, nameof(fromCommunicationIdentifier));
            Argument.AssertNotNull(customContext, nameof(customContext));

            ToCommunicationIdentifier = toCommunicationIdentifier;
            FromCommunicationIdentifier = fromCommunicationIdentifier;
            CustomContext = customContext;
        }

        /// <summary> Initializes a new instance of <see cref="AcsIncomingCallEventData"/>. </summary>
        /// <param name="toCommunicationIdentifier"> The communication identifier of the target user. </param>
        /// <param name="fromCommunicationIdentifier"> The communication identifier of the user who initiated the call. </param>
        /// <param name="serverCallId"> The Id of the server call. </param>
        /// <param name="callerDisplayName"> Display name of caller. </param>
        /// <param name="customContext"> Custom Context of Incoming Call. </param>
        /// <param name="incomingCallContext"> Signed incoming call context. </param>
        /// <param name="correlationId"> CorrelationId (CallId). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AcsIncomingCallEventData(CommunicationIdentifierModel toCommunicationIdentifier, CommunicationIdentifierModel fromCommunicationIdentifier, string serverCallId, string callerDisplayName, AcsIncomingCallCustomContext customContext, string incomingCallContext, string correlationId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ToCommunicationIdentifier = toCommunicationIdentifier;
            FromCommunicationIdentifier = fromCommunicationIdentifier;
            ServerCallId = serverCallId;
            CallerDisplayName = callerDisplayName;
            CustomContext = customContext;
            IncomingCallContext = incomingCallContext;
            CorrelationId = correlationId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AcsIncomingCallEventData"/> for deserialization. </summary>
        internal AcsIncomingCallEventData()
        {
        }

        /// <summary> The communication identifier of the target user. </summary>
        public CommunicationIdentifierModel ToCommunicationIdentifier { get; }
        /// <summary> The communication identifier of the user who initiated the call. </summary>
        public CommunicationIdentifierModel FromCommunicationIdentifier { get; }
        /// <summary> The Id of the server call. </summary>
        public string ServerCallId { get; }
        /// <summary> Display name of caller. </summary>
        public string CallerDisplayName { get; }
        /// <summary> Custom Context of Incoming Call. </summary>
        public AcsIncomingCallCustomContext CustomContext { get; }
        /// <summary> Signed incoming call context. </summary>
        public string IncomingCallContext { get; }
        /// <summary> CorrelationId (CallId). </summary>
        public string CorrelationId { get; }
    }
}
