// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class AcsIncomingCallEventData : IUtf8JsonSerializable, IJsonModel<AcsIncomingCallEventData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AcsIncomingCallEventData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AcsIncomingCallEventData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsIncomingCallEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AcsIncomingCallEventData)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("to"u8);
            writer.WriteObjectValue(ToCommunicationIdentifier, options);
            writer.WritePropertyName("from"u8);
            writer.WriteObjectValue(FromCommunicationIdentifier, options);
            if (Optional.IsDefined(ServerCallId))
            {
                writer.WritePropertyName("serverCallId"u8);
                writer.WriteStringValue(ServerCallId);
            }
            if (Optional.IsDefined(CallerDisplayName))
            {
                writer.WritePropertyName("callerDisplayName"u8);
                writer.WriteStringValue(CallerDisplayName);
            }
            writer.WritePropertyName("customContext"u8);
            writer.WriteObjectValue(CustomContext, options);
            if (Optional.IsDefined(IncomingCallContext))
            {
                writer.WritePropertyName("incomingCallContext"u8);
                writer.WriteStringValue(IncomingCallContext);
            }
            if (Optional.IsDefined(CorrelationId))
            {
                writer.WritePropertyName("correlationId"u8);
                writer.WriteStringValue(CorrelationId);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AcsIncomingCallEventData IJsonModel<AcsIncomingCallEventData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsIncomingCallEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AcsIncomingCallEventData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAcsIncomingCallEventData(document.RootElement, options);
        }

        internal static AcsIncomingCallEventData DeserializeAcsIncomingCallEventData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            CommunicationIdentifierModel to = default;
            CommunicationIdentifierModel @from = default;
            string serverCallId = default;
            string callerDisplayName = default;
            AcsIncomingCallCustomContext customContext = default;
            string incomingCallContext = default;
            string correlationId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("to"u8))
                {
                    to = CommunicationIdentifierModel.DeserializeCommunicationIdentifierModel(property.Value, options);
                    continue;
                }
                if (property.NameEquals("from"u8))
                {
                    @from = CommunicationIdentifierModel.DeserializeCommunicationIdentifierModel(property.Value, options);
                    continue;
                }
                if (property.NameEquals("serverCallId"u8))
                {
                    serverCallId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("callerDisplayName"u8))
                {
                    callerDisplayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("customContext"u8))
                {
                    customContext = AcsIncomingCallCustomContext.DeserializeAcsIncomingCallCustomContext(property.Value, options);
                    continue;
                }
                if (property.NameEquals("incomingCallContext"u8))
                {
                    incomingCallContext = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("correlationId"u8))
                {
                    correlationId = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AcsIncomingCallEventData(
                to,
                @from,
                serverCallId,
                callerDisplayName,
                customContext,
                incomingCallContext,
                correlationId,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AcsIncomingCallEventData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsIncomingCallEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AcsIncomingCallEventData)} does not support writing '{options.Format}' format.");
            }
        }

        AcsIncomingCallEventData IPersistableModel<AcsIncomingCallEventData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsIncomingCallEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAcsIncomingCallEventData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AcsIncomingCallEventData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AcsIncomingCallEventData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcsIncomingCallEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsIncomingCallEventData(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
