// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.EmailEngagementTrackingReportReceived event. </summary>
    public partial class AcsEmailEngagementTrackingReportReceivedEventData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AcsEmailEngagementTrackingReportReceivedEventData"/>. </summary>
        /// <param name="userActionTimestamp"> The time at which the user interacted with the email. </param>
        /// <param name="engagement"> The type of engagement user have with email. </param>
        internal AcsEmailEngagementTrackingReportReceivedEventData(DateTimeOffset userActionTimestamp, AcsUserEngagement engagement)
        {
            UserActionTimestamp = userActionTimestamp;
            Engagement = engagement;
        }

        /// <summary> Initializes a new instance of <see cref="AcsEmailEngagementTrackingReportReceivedEventData"/>. </summary>
        /// <param name="sender"> The Sender Email Address. </param>
        /// <param name="recipient"> The Recipient Email Address. </param>
        /// <param name="messageId"> The Id of the email that has been sent. </param>
        /// <param name="userActionTimestamp"> The time at which the user interacted with the email. </param>
        /// <param name="engagementContext"> The context of the type of engagement user had with email. </param>
        /// <param name="userAgent"> The user agent interacting with the email. </param>
        /// <param name="engagement"> The type of engagement user have with email. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AcsEmailEngagementTrackingReportReceivedEventData(string sender, string recipient, string messageId, DateTimeOffset userActionTimestamp, string engagementContext, string userAgent, AcsUserEngagement engagement, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Sender = sender;
            Recipient = recipient;
            MessageId = messageId;
            UserActionTimestamp = userActionTimestamp;
            EngagementContext = engagementContext;
            UserAgent = userAgent;
            Engagement = engagement;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AcsEmailEngagementTrackingReportReceivedEventData"/> for deserialization. </summary>
        internal AcsEmailEngagementTrackingReportReceivedEventData()
        {
        }

        /// <summary> The Sender Email Address. </summary>
        public string Sender { get; }
        /// <summary> The Recipient Email Address. </summary>
        public string Recipient { get; }
        /// <summary> The Id of the email that has been sent. </summary>
        public string MessageId { get; }
        /// <summary> The time at which the user interacted with the email. </summary>
        public DateTimeOffset UserActionTimestamp { get; }
        /// <summary> The context of the type of engagement user had with email. </summary>
        public string EngagementContext { get; }
        /// <summary> The user agent interacting with the email. </summary>
        public string UserAgent { get; }
        /// <summary> The type of engagement user have with email. </summary>
        public AcsUserEngagement Engagement { get; }
    }
}
