// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class AcsEmailEngagementTrackingReportReceivedEventData : IUtf8JsonSerializable, IJsonModel<AcsEmailEngagementTrackingReportReceivedEventData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AcsEmailEngagementTrackingReportReceivedEventData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AcsEmailEngagementTrackingReportReceivedEventData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsEmailEngagementTrackingReportReceivedEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AcsEmailEngagementTrackingReportReceivedEventData)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Sender))
            {
                writer.WritePropertyName("sender"u8);
                writer.WriteStringValue(Sender);
            }
            if (Optional.IsDefined(Recipient))
            {
                writer.WritePropertyName("recipient"u8);
                writer.WriteStringValue(Recipient);
            }
            if (Optional.IsDefined(MessageId))
            {
                writer.WritePropertyName("messageId"u8);
                writer.WriteStringValue(MessageId);
            }
            writer.WritePropertyName("userActionTimeStamp"u8);
            writer.WriteStringValue(UserActionTimestamp, "O");
            if (Optional.IsDefined(EngagementContext))
            {
                writer.WritePropertyName("engagementContext"u8);
                writer.WriteStringValue(EngagementContext);
            }
            if (Optional.IsDefined(UserAgent))
            {
                writer.WritePropertyName("userAgent"u8);
                writer.WriteStringValue(UserAgent);
            }
            writer.WritePropertyName("engagementType"u8);
            writer.WriteStringValue(Engagement.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AcsEmailEngagementTrackingReportReceivedEventData IJsonModel<AcsEmailEngagementTrackingReportReceivedEventData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsEmailEngagementTrackingReportReceivedEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AcsEmailEngagementTrackingReportReceivedEventData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAcsEmailEngagementTrackingReportReceivedEventData(document.RootElement, options);
        }

        internal static AcsEmailEngagementTrackingReportReceivedEventData DeserializeAcsEmailEngagementTrackingReportReceivedEventData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string sender = default;
            string recipient = default;
            string messageId = default;
            DateTimeOffset userActionTimeStamp = default;
            string engagementContext = default;
            string userAgent = default;
            AcsUserEngagement engagementType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sender"u8))
                {
                    sender = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("recipient"u8))
                {
                    recipient = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("messageId"u8))
                {
                    messageId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("userActionTimeStamp"u8))
                {
                    userActionTimeStamp = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("engagementContext"u8))
                {
                    engagementContext = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("userAgent"u8))
                {
                    userAgent = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("engagementType"u8))
                {
                    engagementType = new AcsUserEngagement(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AcsEmailEngagementTrackingReportReceivedEventData(
                sender,
                recipient,
                messageId,
                userActionTimeStamp,
                engagementContext,
                userAgent,
                engagementType,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AcsEmailEngagementTrackingReportReceivedEventData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsEmailEngagementTrackingReportReceivedEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AcsEmailEngagementTrackingReportReceivedEventData)} does not support writing '{options.Format}' format.");
            }
        }

        AcsEmailEngagementTrackingReportReceivedEventData IPersistableModel<AcsEmailEngagementTrackingReportReceivedEventData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsEmailEngagementTrackingReportReceivedEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAcsEmailEngagementTrackingReportReceivedEventData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AcsEmailEngagementTrackingReportReceivedEventData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AcsEmailEngagementTrackingReportReceivedEventData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcsEmailEngagementTrackingReportReceivedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsEmailEngagementTrackingReportReceivedEventData(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
