// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> The status of the email. Any value other than Delivered is considered failed. </summary>
    public readonly partial struct AcsEmailDeliveryReportStatus : IEquatable<AcsEmailDeliveryReportStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AcsEmailDeliveryReportStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AcsEmailDeliveryReportStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BouncedValue = "Bounced";
        private const string DeliveredValue = "Delivered";
        private const string FailedValue = "Failed";
        private const string FilteredSpamValue = "FilteredSpam";
        private const string QuarantinedValue = "Quarantined";
        private const string SuppressedValue = "Suppressed";

        /// <summary> Hard bounce detected while sending the email. </summary>
        public static AcsEmailDeliveryReportStatus Bounced { get; } = new AcsEmailDeliveryReportStatus(BouncedValue);
        /// <summary> The email was delivered. </summary>
        public static AcsEmailDeliveryReportStatus Delivered { get; } = new AcsEmailDeliveryReportStatus(DeliveredValue);
        /// <summary> The email failed to be delivered. </summary>
        public static AcsEmailDeliveryReportStatus Failed { get; } = new AcsEmailDeliveryReportStatus(FailedValue);
        /// <summary> The message was identified as spam and was rejected or blocked (not quarantined). </summary>
        public static AcsEmailDeliveryReportStatus FilteredSpam { get; } = new AcsEmailDeliveryReportStatus(FilteredSpamValue);
        /// <summary> The message was quarantined (as spam, bulk mail, or phishing). For more information, see Quarantined email messages in EOP (EXCHANGE ONLINE PROTECTION). </summary>
        public static AcsEmailDeliveryReportStatus Quarantined { get; } = new AcsEmailDeliveryReportStatus(QuarantinedValue);
        /// <summary> The email was suppressed. </summary>
        public static AcsEmailDeliveryReportStatus Suppressed { get; } = new AcsEmailDeliveryReportStatus(SuppressedValue);
        /// <summary> Determines if two <see cref="AcsEmailDeliveryReportStatus"/> values are the same. </summary>
        public static bool operator ==(AcsEmailDeliveryReportStatus left, AcsEmailDeliveryReportStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AcsEmailDeliveryReportStatus"/> values are not the same. </summary>
        public static bool operator !=(AcsEmailDeliveryReportStatus left, AcsEmailDeliveryReportStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AcsEmailDeliveryReportStatus"/>. </summary>
        public static implicit operator AcsEmailDeliveryReportStatus(string value) => new AcsEmailDeliveryReportStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AcsEmailDeliveryReportStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AcsEmailDeliveryReportStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
