// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class AcsEmailDeliveryReportReceivedEventData : IUtf8JsonSerializable, IJsonModel<AcsEmailDeliveryReportReceivedEventData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AcsEmailDeliveryReportReceivedEventData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AcsEmailDeliveryReportReceivedEventData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsEmailDeliveryReportReceivedEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AcsEmailDeliveryReportReceivedEventData)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Sender))
            {
                writer.WritePropertyName("sender"u8);
                writer.WriteStringValue(Sender);
            }
            if (Optional.IsDefined(Recipient))
            {
                writer.WritePropertyName("recipient"u8);
                writer.WriteStringValue(Recipient);
            }
            if (Optional.IsDefined(MessageId))
            {
                writer.WritePropertyName("messageId"u8);
                writer.WriteStringValue(MessageId);
            }
            writer.WritePropertyName("status"u8);
            writer.WriteStringValue(Status.ToString());
            writer.WritePropertyName("deliveryStatusDetails"u8);
            writer.WriteObjectValue(DeliveryStatusDetails, options);
            writer.WritePropertyName("deliveryAttemptTimeStamp"u8);
            writer.WriteStringValue(DeliveryAttemptTimestamp, "O");
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AcsEmailDeliveryReportReceivedEventData IJsonModel<AcsEmailDeliveryReportReceivedEventData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsEmailDeliveryReportReceivedEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AcsEmailDeliveryReportReceivedEventData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAcsEmailDeliveryReportReceivedEventData(document.RootElement, options);
        }

        internal static AcsEmailDeliveryReportReceivedEventData DeserializeAcsEmailDeliveryReportReceivedEventData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string sender = default;
            string recipient = default;
            string messageId = default;
            AcsEmailDeliveryReportStatus status = default;
            AcsEmailDeliveryReportStatusDetails deliveryStatusDetails = default;
            DateTimeOffset deliveryAttemptTimeStamp = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sender"u8))
                {
                    sender = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("recipient"u8))
                {
                    recipient = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("messageId"u8))
                {
                    messageId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    status = new AcsEmailDeliveryReportStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("deliveryStatusDetails"u8))
                {
                    deliveryStatusDetails = AcsEmailDeliveryReportStatusDetails.DeserializeAcsEmailDeliveryReportStatusDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("deliveryAttemptTimeStamp"u8))
                {
                    deliveryAttemptTimeStamp = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AcsEmailDeliveryReportReceivedEventData(
                sender,
                recipient,
                messageId,
                status,
                deliveryStatusDetails,
                deliveryAttemptTimeStamp,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AcsEmailDeliveryReportReceivedEventData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsEmailDeliveryReportReceivedEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AcsEmailDeliveryReportReceivedEventData)} does not support writing '{options.Format}' format.");
            }
        }

        AcsEmailDeliveryReportReceivedEventData IPersistableModel<AcsEmailDeliveryReportReceivedEventData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AcsEmailDeliveryReportReceivedEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAcsEmailDeliveryReportReceivedEventData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AcsEmailDeliveryReportReceivedEventData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AcsEmailDeliveryReportReceivedEventData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcsEmailDeliveryReportReceivedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsEmailDeliveryReportReceivedEventData(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
