// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of common properties of all chat thread events. </summary>
    public partial class AcsChatThreadEventBaseProperties : AcsChatEventBaseProperties
    {
        /// <summary> Initializes a new instance of <see cref="AcsChatThreadEventBaseProperties"/>. </summary>
        /// <param name="recipientCommunicationIdentifier"> The communication identifier of the target user. </param>
        /// <param name="createTime"> The original creation time of the thread. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="recipientCommunicationIdentifier"/> is null. </exception>
        internal AcsChatThreadEventBaseProperties(CommunicationIdentifierModel recipientCommunicationIdentifier, DateTimeOffset createTime) : base(recipientCommunicationIdentifier)
        {
            Argument.AssertNotNull(recipientCommunicationIdentifier, nameof(recipientCommunicationIdentifier));

            CreateTime = createTime;
        }

        /// <summary> Initializes a new instance of <see cref="AcsChatThreadEventBaseProperties"/>. </summary>
        /// <param name="recipientCommunicationIdentifier"> The communication identifier of the target user. </param>
        /// <param name="transactionId"> The transaction id will be used as co-relation vector. </param>
        /// <param name="threadId"> The chat thread id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="createTime"> The original creation time of the thread. </param>
        /// <param name="version"> The version of the thread. </param>
        internal AcsChatThreadEventBaseProperties(CommunicationIdentifierModel recipientCommunicationIdentifier, string transactionId, string threadId, IDictionary<string, BinaryData> serializedAdditionalRawData, DateTimeOffset createTime, long? version) : base(recipientCommunicationIdentifier, transactionId, threadId, serializedAdditionalRawData)
        {
            CreateTime = createTime;
            Version = version;
        }

        /// <summary> Initializes a new instance of <see cref="AcsChatThreadEventBaseProperties"/> for deserialization. </summary>
        internal AcsChatThreadEventBaseProperties()
        {
        }

        /// <summary> The original creation time of the thread. </summary>
        public DateTimeOffset CreateTime { get; }
        /// <summary> The version of the thread. </summary>
        public long? Version { get; }
    }
}
