// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.ChatParticipantRemovedFromThreadWithUser event. </summary>
    public partial class AcsChatParticipantRemovedFromThreadWithUserEventData : AcsChatThreadEventBaseProperties
    {
        /// <summary> Initializes a new instance of <see cref="AcsChatParticipantRemovedFromThreadWithUserEventData"/>. </summary>
        /// <param name="recipientCommunicationIdentifier"> The communication identifier of the target user. </param>
        /// <param name="createTime"> The original creation time of the thread. </param>
        /// <param name="time"> The time at which the user was removed to the thread. </param>
        /// <param name="removedByCommunicationIdentifier"> The communication identifier of the user who removed the user. </param>
        /// <param name="participantRemoved"> The details of the user who was removed. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="recipientCommunicationIdentifier"/>, <paramref name="removedByCommunicationIdentifier"/> or <paramref name="participantRemoved"/> is null. </exception>
        internal AcsChatParticipantRemovedFromThreadWithUserEventData(CommunicationIdentifierModel recipientCommunicationIdentifier, DateTimeOffset createTime, DateTimeOffset time, CommunicationIdentifierModel removedByCommunicationIdentifier, AcsChatThreadParticipantProperties participantRemoved) : base(recipientCommunicationIdentifier, createTime)
        {
            Argument.AssertNotNull(recipientCommunicationIdentifier, nameof(recipientCommunicationIdentifier));
            Argument.AssertNotNull(removedByCommunicationIdentifier, nameof(removedByCommunicationIdentifier));
            Argument.AssertNotNull(participantRemoved, nameof(participantRemoved));

            Time = time;
            RemovedByCommunicationIdentifier = removedByCommunicationIdentifier;
            ParticipantRemoved = participantRemoved;
        }

        /// <summary> Initializes a new instance of <see cref="AcsChatParticipantRemovedFromThreadWithUserEventData"/>. </summary>
        /// <param name="recipientCommunicationIdentifier"> The communication identifier of the target user. </param>
        /// <param name="transactionId"> The transaction id will be used as co-relation vector. </param>
        /// <param name="threadId"> The chat thread id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="createTime"> The original creation time of the thread. </param>
        /// <param name="version"> The version of the thread. </param>
        /// <param name="time"> The time at which the user was removed to the thread. </param>
        /// <param name="removedByCommunicationIdentifier"> The communication identifier of the user who removed the user. </param>
        /// <param name="participantRemoved"> The details of the user who was removed. </param>
        internal AcsChatParticipantRemovedFromThreadWithUserEventData(CommunicationIdentifierModel recipientCommunicationIdentifier, string transactionId, string threadId, IDictionary<string, BinaryData> serializedAdditionalRawData, DateTimeOffset createTime, long? version, DateTimeOffset time, CommunicationIdentifierModel removedByCommunicationIdentifier, AcsChatThreadParticipantProperties participantRemoved) : base(recipientCommunicationIdentifier, transactionId, threadId, serializedAdditionalRawData, createTime, version)
        {
            Time = time;
            RemovedByCommunicationIdentifier = removedByCommunicationIdentifier;
            ParticipantRemoved = participantRemoved;
        }

        /// <summary> Initializes a new instance of <see cref="AcsChatParticipantRemovedFromThreadWithUserEventData"/> for deserialization. </summary>
        internal AcsChatParticipantRemovedFromThreadWithUserEventData()
        {
        }

        /// <summary> The time at which the user was removed to the thread. </summary>
        public DateTimeOffset Time { get; }
        /// <summary> The communication identifier of the user who removed the user. </summary>
        public CommunicationIdentifierModel RemovedByCommunicationIdentifier { get; }
        /// <summary> The details of the user who was removed. </summary>
        public AcsChatThreadParticipantProperties ParticipantRemoved { get; }
    }
}
