// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.ChatMessageReceived event. </summary>
    public partial class AcsChatMessageReceivedEventData : AcsChatMessageEventBaseProperties
    {
        /// <summary> Initializes a new instance of <see cref="AcsChatMessageReceivedEventData"/>. </summary>
        /// <param name="recipientCommunicationIdentifier"> The communication identifier of the target user. </param>
        /// <param name="senderCommunicationIdentifier"> The communication identifier of the sender. </param>
        /// <param name="composeTime"> The original compose time of the message. </param>
        /// <param name="metadata"> The chat message metadata. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="recipientCommunicationIdentifier"/>, <paramref name="senderCommunicationIdentifier"/> or <paramref name="metadata"/> is null. </exception>
        internal AcsChatMessageReceivedEventData(CommunicationIdentifierModel recipientCommunicationIdentifier, CommunicationIdentifierModel senderCommunicationIdentifier, DateTimeOffset composeTime, IReadOnlyDictionary<string, string> metadata) : base(recipientCommunicationIdentifier, senderCommunicationIdentifier, composeTime)
        {
            Argument.AssertNotNull(recipientCommunicationIdentifier, nameof(recipientCommunicationIdentifier));
            Argument.AssertNotNull(senderCommunicationIdentifier, nameof(senderCommunicationIdentifier));
            Argument.AssertNotNull(metadata, nameof(metadata));

            Metadata = metadata;
        }

        /// <summary> Initializes a new instance of <see cref="AcsChatMessageReceivedEventData"/>. </summary>
        /// <param name="recipientCommunicationIdentifier"> The communication identifier of the target user. </param>
        /// <param name="transactionId"> The transaction id will be used as co-relation vector. </param>
        /// <param name="threadId"> The chat thread id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="messageId"> The chat message id. </param>
        /// <param name="senderCommunicationIdentifier"> The communication identifier of the sender. </param>
        /// <param name="senderDisplayName"> The display name of the sender. </param>
        /// <param name="composeTime"> The original compose time of the message. </param>
        /// <param name="type"> The type of the message. </param>
        /// <param name="version"> The version of the message. </param>
        /// <param name="messageBody"> The body of the chat message. </param>
        /// <param name="metadata"> The chat message metadata. </param>
        internal AcsChatMessageReceivedEventData(CommunicationIdentifierModel recipientCommunicationIdentifier, string transactionId, string threadId, IDictionary<string, BinaryData> serializedAdditionalRawData, string messageId, CommunicationIdentifierModel senderCommunicationIdentifier, string senderDisplayName, DateTimeOffset composeTime, string type, long? version, string messageBody, IReadOnlyDictionary<string, string> metadata) : base(recipientCommunicationIdentifier, transactionId, threadId, serializedAdditionalRawData, messageId, senderCommunicationIdentifier, senderDisplayName, composeTime, type, version)
        {
            MessageBody = messageBody;
            Metadata = metadata;
        }

        /// <summary> Initializes a new instance of <see cref="AcsChatMessageReceivedEventData"/> for deserialization. </summary>
        internal AcsChatMessageReceivedEventData()
        {
        }

        /// <summary> The body of the chat message. </summary>
        public string MessageBody { get; }
        /// <summary> The chat message metadata. </summary>
        public IReadOnlyDictionary<string, string> Metadata { get; }
    }
}
