// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Messaging.EventGrid.Namespaces
{
    /// <summary> The RenewLocksRequest. </summary>
    internal partial class RenewLocksRequest
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RenewLocksRequest"/>. </summary>
        /// <param name="lockTokens"> Array of lock tokens. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="lockTokens"/> is null. </exception>
        internal RenewLocksRequest(IEnumerable<string> lockTokens)
        {
            Argument.AssertNotNull(lockTokens, nameof(lockTokens));

            LockTokens = lockTokens.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="RenewLocksRequest"/>. </summary>
        /// <param name="lockTokens"> Array of lock tokens. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RenewLocksRequest(IReadOnlyList<string> lockTokens, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LockTokens = lockTokens;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="RenewLocksRequest"/> for deserialization. </summary>
        internal RenewLocksRequest()
        {
        }

        /// <summary> Array of lock tokens. </summary>
        public IReadOnlyList<string> LockTokens { get; }
    }
}
