// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Messaging.EventGrid.Namespaces
{
    /// <summary> Details of the Receive operation response. </summary>
    public partial class ReceiveResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ReceiveResult"/>. </summary>
        /// <param name="details"> Array of receive responses, one per cloud event. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="details"/> is null. </exception>
        internal ReceiveResult(IEnumerable<ReceiveDetails> details)
        {
            Argument.AssertNotNull(details, nameof(details));

            Details = details.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ReceiveResult"/>. </summary>
        /// <param name="details"> Array of receive responses, one per cloud event. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ReceiveResult(IReadOnlyList<ReceiveDetails> details, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Details = details;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ReceiveResult"/> for deserialization. </summary>
        internal ReceiveResult()
        {
        }

        /// <summary> Array of receive responses, one per cloud event. </summary>
        public IReadOnlyList<ReceiveDetails> Details { get; }
    }
}
