// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.Namespaces
{
    /// <summary> Failed LockToken information. </summary>
    public partial class FailedLockToken
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FailedLockToken"/>. </summary>
        /// <param name="lockToken"> The lock token of an entry in the request. </param>
        /// <param name="error"> Error information of the failed operation result for the lock token in the request. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="lockToken"/> or <paramref name="error"/> is null. </exception>
        internal FailedLockToken(string lockToken, ResponseError error)
        {
            Argument.AssertNotNull(lockToken, nameof(lockToken));
            Argument.AssertNotNull(error, nameof(error));

            LockToken = lockToken;
            Error = error;
        }

        /// <summary> Initializes a new instance of <see cref="FailedLockToken"/>. </summary>
        /// <param name="lockToken"> The lock token of an entry in the request. </param>
        /// <param name="error"> Error information of the failed operation result for the lock token in the request. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FailedLockToken(string lockToken, ResponseError error, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LockToken = lockToken;
            Error = error;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FailedLockToken"/> for deserialization. </summary>
        internal FailedLockToken()
        {
        }

        /// <summary> The lock token of an entry in the request. </summary>
        public string LockToken { get; }
        /// <summary> Error information of the failed operation result for the lock token in the request. </summary>
        public ResponseError Error { get; }
    }
}
