// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.Namespaces
{
    /// <summary> Properties of the Event Broker operation. </summary>
    public partial class BrokerProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BrokerProperties"/>. </summary>
        /// <param name="lockToken"> The token of the lock on the event. </param>
        /// <param name="deliveryCount"> The attempt count for delivering the event. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="lockToken"/> is null. </exception>
        internal BrokerProperties(string lockToken, int deliveryCount)
        {
            Argument.AssertNotNull(lockToken, nameof(lockToken));

            LockToken = lockToken;
            DeliveryCount = deliveryCount;
        }

        /// <summary> Initializes a new instance of <see cref="BrokerProperties"/>. </summary>
        /// <param name="lockToken"> The token of the lock on the event. </param>
        /// <param name="deliveryCount"> The attempt count for delivering the event. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BrokerProperties(string lockToken, int deliveryCount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LockToken = lockToken;
            DeliveryCount = deliveryCount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BrokerProperties"/> for deserialization. </summary>
        internal BrokerProperties()
        {
        }

        /// <summary> The token of the lock on the event. </summary>
        public string LockToken { get; }
        /// <summary> The attempt count for delivering the event. </summary>
        public int DeliveryCount { get; }
    }
}
