// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ElasticSan.Models
{
    /// <summary> Scale up properties on Elastic San Appliance. </summary>
    public partial class ScaleUpProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ScaleUpProperties"/>. </summary>
        public ScaleUpProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ScaleUpProperties"/>. </summary>
        /// <param name="unusedSizeTiB"> Unused size on Elastic San appliance in TiB. </param>
        /// <param name="increaseCapacityUnitByTiB"> Unit to increase Capacity Unit on Elastic San appliance in TiB. </param>
        /// <param name="capacityUnitScaleUpLimitTiB"> Maximum scale up size on Elastic San appliance in TiB. </param>
        /// <param name="autoScalePolicyEnforcement"> Enable or Disable scale up setting on Elastic San Appliance. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ScaleUpProperties(long? unusedSizeTiB, long? increaseCapacityUnitByTiB, long? capacityUnitScaleUpLimitTiB, AutoScalePolicyEnforcement? autoScalePolicyEnforcement, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UnusedSizeTiB = unusedSizeTiB;
            IncreaseCapacityUnitByTiB = increaseCapacityUnitByTiB;
            CapacityUnitScaleUpLimitTiB = capacityUnitScaleUpLimitTiB;
            AutoScalePolicyEnforcement = autoScalePolicyEnforcement;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Unused size on Elastic San appliance in TiB. </summary>
        public long? UnusedSizeTiB { get; set; }
        /// <summary> Unit to increase Capacity Unit on Elastic San appliance in TiB. </summary>
        public long? IncreaseCapacityUnitByTiB { get; set; }
        /// <summary> Maximum scale up size on Elastic San appliance in TiB. </summary>
        public long? CapacityUnitScaleUpLimitTiB { get; set; }
        /// <summary> Enable or Disable scale up setting on Elastic San Appliance. </summary>
        public AutoScalePolicyEnforcement? AutoScalePolicyEnforcement { get; set; }
    }
}
