// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ElasticSan.Models
{
    public partial class ScaleUpProperties : IUtf8JsonSerializable, IJsonModel<ScaleUpProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ScaleUpProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ScaleUpProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScaleUpProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScaleUpProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(UnusedSizeTiB))
            {
                writer.WritePropertyName("unusedSizeTiB"u8);
                writer.WriteNumberValue(UnusedSizeTiB.Value);
            }
            if (Optional.IsDefined(IncreaseCapacityUnitByTiB))
            {
                writer.WritePropertyName("increaseCapacityUnitByTiB"u8);
                writer.WriteNumberValue(IncreaseCapacityUnitByTiB.Value);
            }
            if (Optional.IsDefined(CapacityUnitScaleUpLimitTiB))
            {
                writer.WritePropertyName("capacityUnitScaleUpLimitTiB"u8);
                writer.WriteNumberValue(CapacityUnitScaleUpLimitTiB.Value);
            }
            if (Optional.IsDefined(AutoScalePolicyEnforcement))
            {
                writer.WritePropertyName("autoScalePolicyEnforcement"u8);
                writer.WriteStringValue(AutoScalePolicyEnforcement.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ScaleUpProperties IJsonModel<ScaleUpProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScaleUpProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScaleUpProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeScaleUpProperties(document.RootElement, options);
        }

        internal static ScaleUpProperties DeserializeScaleUpProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            long? unusedSizeTiB = default;
            long? increaseCapacityUnitByTiB = default;
            long? capacityUnitScaleUpLimitTiB = default;
            AutoScalePolicyEnforcement? autoScalePolicyEnforcement = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("unusedSizeTiB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    unusedSizeTiB = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("increaseCapacityUnitByTiB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    increaseCapacityUnitByTiB = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("capacityUnitScaleUpLimitTiB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    capacityUnitScaleUpLimitTiB = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("autoScalePolicyEnforcement"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    autoScalePolicyEnforcement = new AutoScalePolicyEnforcement(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ScaleUpProperties(unusedSizeTiB, increaseCapacityUnitByTiB, capacityUnitScaleUpLimitTiB, autoScalePolicyEnforcement, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ScaleUpProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScaleUpProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ScaleUpProperties)} does not support writing '{options.Format}' format.");
            }
        }

        ScaleUpProperties IPersistableModel<ScaleUpProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScaleUpProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeScaleUpProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ScaleUpProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ScaleUpProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
