// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ElasticSan.Models
{
    /// <summary> This enumerates the possible sources of a volume creation. </summary>
    public readonly partial struct ElasticSanVolumeCreateOption : IEquatable<ElasticSanVolumeCreateOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ElasticSanVolumeCreateOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ElasticSanVolumeCreateOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string VolumeSnapshotValue = "VolumeSnapshot";
        private const string DiskSnapshotValue = "DiskSnapshot";
        private const string DiskValue = "Disk";
        private const string DiskRestorePointValue = "DiskRestorePoint";

        /// <summary> None. </summary>
        public static ElasticSanVolumeCreateOption None { get; } = new ElasticSanVolumeCreateOption(NoneValue);
        /// <summary> VolumeSnapshot. </summary>
        public static ElasticSanVolumeCreateOption VolumeSnapshot { get; } = new ElasticSanVolumeCreateOption(VolumeSnapshotValue);
        /// <summary> DiskSnapshot. </summary>
        public static ElasticSanVolumeCreateOption DiskSnapshot { get; } = new ElasticSanVolumeCreateOption(DiskSnapshotValue);
        /// <summary> Disk. </summary>
        public static ElasticSanVolumeCreateOption Disk { get; } = new ElasticSanVolumeCreateOption(DiskValue);
        /// <summary> DiskRestorePoint. </summary>
        public static ElasticSanVolumeCreateOption DiskRestorePoint { get; } = new ElasticSanVolumeCreateOption(DiskRestorePointValue);
        /// <summary> Determines if two <see cref="ElasticSanVolumeCreateOption"/> values are the same. </summary>
        public static bool operator ==(ElasticSanVolumeCreateOption left, ElasticSanVolumeCreateOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ElasticSanVolumeCreateOption"/> values are not the same. </summary>
        public static bool operator !=(ElasticSanVolumeCreateOption left, ElasticSanVolumeCreateOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ElasticSanVolumeCreateOption"/>. </summary>
        public static implicit operator ElasticSanVolumeCreateOption(string value) => new ElasticSanVolumeCreateOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ElasticSanVolumeCreateOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ElasticSanVolumeCreateOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
