// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ElasticSan.Models
{
    /// <summary> Storage Target type. </summary>
    public readonly partial struct ElasticSanStorageTargetType : IEquatable<ElasticSanStorageTargetType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ElasticSanStorageTargetType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ElasticSanStorageTargetType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IscsiValue = "Iscsi";
        private const string NoneValue = "None";

        /// <summary> Iscsi. </summary>
        public static ElasticSanStorageTargetType Iscsi { get; } = new ElasticSanStorageTargetType(IscsiValue);
        /// <summary> None. </summary>
        public static ElasticSanStorageTargetType None { get; } = new ElasticSanStorageTargetType(NoneValue);
        /// <summary> Determines if two <see cref="ElasticSanStorageTargetType"/> values are the same. </summary>
        public static bool operator ==(ElasticSanStorageTargetType left, ElasticSanStorageTargetType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ElasticSanStorageTargetType"/> values are not the same. </summary>
        public static bool operator !=(ElasticSanStorageTargetType left, ElasticSanStorageTargetType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ElasticSanStorageTargetType"/>. </summary>
        public static implicit operator ElasticSanStorageTargetType(string value) => new ElasticSanStorageTargetType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ElasticSanStorageTargetType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ElasticSanStorageTargetType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
