// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ElasticSan.Models
{
    /// <summary> The sku name. </summary>
    public readonly partial struct ElasticSanSkuName : IEquatable<ElasticSanSkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ElasticSanSkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ElasticSanSkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PremiumLrsValue = "Premium_LRS";
        private const string PremiumZrsValue = "Premium_ZRS";

        /// <summary> Premium locally redundant storage. </summary>
        public static ElasticSanSkuName PremiumLrs { get; } = new ElasticSanSkuName(PremiumLrsValue);
        /// <summary> Premium zone redundant storage. </summary>
        public static ElasticSanSkuName PremiumZrs { get; } = new ElasticSanSkuName(PremiumZrsValue);
        /// <summary> Determines if two <see cref="ElasticSanSkuName"/> values are the same. </summary>
        public static bool operator ==(ElasticSanSkuName left, ElasticSanSkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ElasticSanSkuName"/> values are not the same. </summary>
        public static bool operator !=(ElasticSanSkuName left, ElasticSanSkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ElasticSanSkuName"/>. </summary>
        public static implicit operator ElasticSanSkuName(string value) => new ElasticSanSkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ElasticSanSkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ElasticSanSkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
