// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ElasticSan.Models
{
    /// <summary> Provisioning state of the iSCSI Target. </summary>
    public readonly partial struct ElasticSanProvisioningState : IEquatable<ElasticSanProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ElasticSanProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ElasticSanProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string PendingValue = "Pending";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";

        /// <summary> Invalid. </summary>
        public static ElasticSanProvisioningState Invalid { get; } = new ElasticSanProvisioningState(InvalidValue);
        /// <summary> Succeeded. </summary>
        public static ElasticSanProvisioningState Succeeded { get; } = new ElasticSanProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static ElasticSanProvisioningState Failed { get; } = new ElasticSanProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static ElasticSanProvisioningState Canceled { get; } = new ElasticSanProvisioningState(CanceledValue);
        /// <summary> Pending. </summary>
        public static ElasticSanProvisioningState Pending { get; } = new ElasticSanProvisioningState(PendingValue);
        /// <summary> Creating. </summary>
        public static ElasticSanProvisioningState Creating { get; } = new ElasticSanProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static ElasticSanProvisioningState Updating { get; } = new ElasticSanProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static ElasticSanProvisioningState Deleting { get; } = new ElasticSanProvisioningState(DeletingValue);
        /// <summary> Determines if two <see cref="ElasticSanProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ElasticSanProvisioningState left, ElasticSanProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ElasticSanProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ElasticSanProvisioningState left, ElasticSanProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ElasticSanProvisioningState"/>. </summary>
        public static implicit operator ElasticSanProvisioningState(string value) => new ElasticSanProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ElasticSanProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ElasticSanProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
