// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ElasticSan.Models
{
    /// <summary> The type of key used to encrypt the data of the disk. </summary>
    public readonly partial struct ElasticSanEncryptionType : IEquatable<ElasticSanEncryptionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ElasticSanEncryptionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ElasticSanEncryptionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EncryptionAtRestWithPlatformKeyValue = "EncryptionAtRestWithPlatformKey";
        private const string EncryptionAtRestWithCustomerManagedKeyValue = "EncryptionAtRestWithCustomerManagedKey";

        /// <summary> Volume is encrypted at rest with Platform managed key. It is the default encryption type. </summary>
        public static ElasticSanEncryptionType EncryptionAtRestWithPlatformKey { get; } = new ElasticSanEncryptionType(EncryptionAtRestWithPlatformKeyValue);
        /// <summary> Volume is encrypted at rest with Customer managed key that can be changed and revoked by a customer. </summary>
        public static ElasticSanEncryptionType EncryptionAtRestWithCustomerManagedKey { get; } = new ElasticSanEncryptionType(EncryptionAtRestWithCustomerManagedKeyValue);
        /// <summary> Determines if two <see cref="ElasticSanEncryptionType"/> values are the same. </summary>
        public static bool operator ==(ElasticSanEncryptionType left, ElasticSanEncryptionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ElasticSanEncryptionType"/> values are not the same. </summary>
        public static bool operator !=(ElasticSanEncryptionType left, ElasticSanEncryptionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ElasticSanEncryptionType"/>. </summary>
        public static implicit operator ElasticSanEncryptionType(string value) => new ElasticSanEncryptionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ElasticSanEncryptionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ElasticSanEncryptionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
