// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ElasticSan.Models
{
    /// <summary> The encryption settings on the volume group. </summary>
    public partial class ElasticSanEncryptionProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ElasticSanEncryptionProperties"/>. </summary>
        public ElasticSanEncryptionProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ElasticSanEncryptionProperties"/>. </summary>
        /// <param name="keyVaultProperties"> Properties provided by key vault. </param>
        /// <param name="encryptionIdentity"> The identity to be used with service-side encryption at rest. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ElasticSanEncryptionProperties(ElasticSanKeyVaultProperties keyVaultProperties, EncryptionIdentity encryptionIdentity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyVaultProperties = keyVaultProperties;
            EncryptionIdentity = encryptionIdentity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Properties provided by key vault. </summary>
        public ElasticSanKeyVaultProperties KeyVaultProperties { get; set; }
        /// <summary> The identity to be used with service-side encryption at rest. </summary>
        internal EncryptionIdentity EncryptionIdentity { get; set; }
        /// <summary> Resource identifier of the UserAssigned identity to be associated with server-side encryption on the volume group. </summary>
        public ResourceIdentifier EncryptionUserAssignedIdentity
        {
            get => EncryptionIdentity is null ? default : EncryptionIdentity.EncryptionUserAssignedIdentity;
            set
            {
                if (EncryptionIdentity is null)
                    EncryptionIdentity = new EncryptionIdentity();
                EncryptionIdentity.EncryptionUserAssignedIdentity = value;
            }
        }
    }
}
