// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ElasticSan.Models
{
    /// <summary> Enable or Disable scale up setting on Elastic San Appliance. </summary>
    public readonly partial struct AutoScalePolicyEnforcement : IEquatable<AutoScalePolicyEnforcement>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutoScalePolicyEnforcement"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutoScalePolicyEnforcement(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> None. </summary>
        public static AutoScalePolicyEnforcement None { get; } = new AutoScalePolicyEnforcement(NoneValue);
        /// <summary> Enabled. </summary>
        public static AutoScalePolicyEnforcement Enabled { get; } = new AutoScalePolicyEnforcement(EnabledValue);
        /// <summary> Disabled. </summary>
        public static AutoScalePolicyEnforcement Disabled { get; } = new AutoScalePolicyEnforcement(DisabledValue);
        /// <summary> Determines if two <see cref="AutoScalePolicyEnforcement"/> values are the same. </summary>
        public static bool operator ==(AutoScalePolicyEnforcement left, AutoScalePolicyEnforcement right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutoScalePolicyEnforcement"/> values are not the same. </summary>
        public static bool operator !=(AutoScalePolicyEnforcement left, AutoScalePolicyEnforcement right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutoScalePolicyEnforcement"/>. </summary>
        public static implicit operator AutoScalePolicyEnforcement(string value) => new AutoScalePolicyEnforcement(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutoScalePolicyEnforcement other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutoScalePolicyEnforcement other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
