// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ElasticSan
{
    internal class ElasticSanSnapshotOperationSource : IOperationSource<ElasticSanSnapshotResource>
    {
        private readonly ArmClient _client;

        internal ElasticSanSnapshotOperationSource(ArmClient client)
        {
            _client = client;
        }

        ElasticSanSnapshotResource IOperationSource<ElasticSanSnapshotResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ElasticSanSnapshotData.DeserializeElasticSanSnapshotData(document.RootElement);
            return new ElasticSanSnapshotResource(_client, data);
        }

        async ValueTask<ElasticSanSnapshotResource> IOperationSource<ElasticSanSnapshotResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ElasticSanSnapshotData.DeserializeElasticSanSnapshotData(document.RootElement);
            return new ElasticSanSnapshotResource(_client, data);
        }
    }
}
